---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：159-Cat セグメントレプリケーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segment_replication.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行160

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/segment_replication と /{index} | E-01, E-02 行49-53 | ○ |
| C-02 | リクエストパラメータにactive_only, bytes, detailed, shards等が存在 | E-01, E-02 行68-75 | ○ |
| C-03 | 基本カラムは8つ（shardId, target_node等） | E-02 行96-104 | ○ |
| C-04 | detailed=true時に追加17カラム | E-02 行105-122 | ○ |
| C-05 | detailedパラメータでステージ別時間を追加表示 | E-02 行105-122, 177-195 | ○ |
| C-06 | シャードIDの昇順でソート | E-02 行151-155 introSort | ○ |
| C-07 | レプリケーション状態がnullの場合はスキップ | E-02 行163-165 | ○ |
| C-08 | shardsパラメータでフィルタリング | E-02 行73 | ○ |
| C-09 | active_onlyパラメータサポート | E-02 行74 | ○ |
| C-10 | IndicesOptionsサポート | E-02 行75 | ○ |
| C-11 | 進捗率は"X.X%"形式で表示 | E-02 行181, 183 | ○ |
| C-12 | 5つのステージ別時間を表示 | E-02 行190-194 | ○ |
| C-13 | bytes_behindはByteSizeValueで表示 | E-02 行173 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードとAPI仕様から直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 基本カラムと詳細カラムの一覧がソースコードと一致しているか
- [ ] リクエストパラメータがcat.segment_replication.jsonの定義と一致しているか
- [ ] detailedモードの条件分岐が正しく記述されているか
